/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.login;

import com.ibm.hwmca.fw.servlet.login.AutoLogonListener;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.util.TimerTaskControl;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AutoLogonRequest {
    private static final String TRACE_MASKT = "XLGNAURT";
    String userid;
    long timeout;
    String recognitionToken;
    TimerTaskControl timerTaskControl;
    List listeners;

    public AutoLogonRequest(String userid) {
        this(userid, 0L);
    }

    public AutoLogonRequest(String userid, long timeout) {
        this.userid = userid;
        this.timeout = timeout;
    }

    public String getUserid() {
        return this.userid;
    }

    public long getTimeout() {
        return this.timeout;
    }

    void setRecognitionToken(String recognitionToken) {
        this.recognitionToken = recognitionToken;
    }

    public String getRecognitionToken() {
        return this.recognitionToken;
    }

    void setTimerTaskControl(TimerTaskControl timerTaskControl) {
        this.timerTaskControl = timerTaskControl;
    }

    TimerTaskControl getTimerTaskControl() {
        return this.timerTaskControl;
    }

    public synchronized void addAutoLogonListener(AutoLogonListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        this.listeners.add(listener);
    }

    public synchronized void removeAutoLogonListener(AutoLogonListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    synchronized void fireAssociatingWithHMCSession(HMCSession hmcSession) {
        if (this.listeners == null) {
            return;
        }
        Trace.trace(TRACE_MASKT, "fireAssociatingWithHMCSession() for " + this);
        Iterator iterator = new ArrayList(this.listeners).iterator();
        while (iterator.hasNext()) {
            AutoLogonListener listener = (AutoLogonListener)iterator.next();
            try {
                listener.associatingWithHMCSession(this, hmcSession);
            }
            catch (Throwable e) {
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
                Trace.trace(TRACE_MASKT, "Ignoring exception from associatingWithHMCSession() event handler:");
                Trace.trace(TRACE_MASKT, e);
            }
        }
    }

    synchronized void fireDisassociatingFromHMCSession(HMCSession hmcSession) {
        if (this.listeners == null) {
            return;
        }
        Trace.trace(TRACE_MASKT, "fireDisassociatingFromHMCSession() for " + this);
        Iterator iterator = new ArrayList(this.listeners).iterator();
        while (iterator.hasNext()) {
            AutoLogonListener listener = (AutoLogonListener)iterator.next();
            try {
                listener.disassociatingFromHMCSession(this, hmcSession);
            }
            catch (Throwable e) {
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
                Trace.trace(TRACE_MASKT, "Ignoring exception from disassociatingFromHMCSession() event handler:");
                Trace.trace(TRACE_MASKT, e);
            }
        }
    }

    synchronized void fireLoggedOffOrDisconnected(HMCSession hmcSession) {
        if (this.listeners == null) {
            return;
        }
        Trace.trace(TRACE_MASKT, "fireLoggedOffOrDisconnected() for " + this);
        Iterator iterator = new ArrayList(this.listeners).iterator();
        while (iterator.hasNext()) {
            AutoLogonListener listener = (AutoLogonListener)iterator.next();
            try {
                listener.loggedOffOrDisconnected(this, hmcSession);
            }
            catch (Throwable e) {
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
                Trace.trace(TRACE_MASKT, "Ignoring exception from loggedOffOrDisconnected() event handler:");
                Trace.trace(TRACE_MASKT, e);
            }
        }
    }

    synchronized void fireTimedOut() {
        if (this.listeners == null) {
            return;
        }
        Trace.trace(TRACE_MASKT, "fireTimedOut() for " + this);
        Iterator iterator = new ArrayList(this.listeners).iterator();
        while (iterator.hasNext()) {
            AutoLogonListener listener = (AutoLogonListener)iterator.next();
            try {
                listener.requestTimedOut(this);
            }
            catch (Throwable e) {
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
                Trace.trace(TRACE_MASKT, "Ignoring exception from requestTimedOut() event handler:");
                Trace.trace(TRACE_MASKT, e);
            }
        }
    }

    public int hashCode() {
        return this.recognitionToken.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AutoLogonRequest)) {
            return false;
        }
        return this.recognitionToken.equals(((AutoLogonRequest)obj).recognitionToken);
    }

    public String toString() {
        return "AutoLogonRequest[userid==" + this.userid + ", timeout==" + this.timeout + ", token==" + this.recognitionToken + ']';
    }
}

